/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.IVWCollectionExtension;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXParseException;

public final class VWScenarioCollectionDefinition
implements Serializable,
IVWCollectionExtension {
    private Map m_scenarioDefs = Collections.synchronizedMap(new HashMap());

    public VWScenarioCollectionDefinition() {
    }

    public VWScenarioCollectionDefinition(VWWorkflowCollectionDefinition wflCollectionDef) throws VWException {
        try {
            VWScenarioDefinition[] scenarioDefs;
            int nExtensionType = 0;
            Object nodeData = wflCollectionDef.registerCollectionExtension(nExtensionType, this);
            if (nodeData != null && (scenarioDefs = VWScenarioXMLHandler.parseXPDLScenarioCollection(nodeData)) != null) {
                for (int nIndex = 0; nIndex < scenarioDefs.length; ++nIndex) {
                    this.addScenario(scenarioDefs[nIndex]);
                }
            }
        }
        catch (SAXParseException err) {
            String errString = "** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getMessage();
            throw new VWException("sim.api.VWScenarioCollectionDefinition.XMLReadParse", "XML Parsing error {0}.", errString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new VWException("sim.api.VWScenarioCollectionDefinition.XMLReadError", " Exception reading XML, {0}.", ex.getMessage());
        }
    }

    public void addScenario(VWScenarioDefinition newScenarioDef) throws VWException {
        if (newScenarioDef == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionNullScenarioAdd", "Cannot add a null scenario into the scenario collection");
        }
        if (newScenarioDef.getName() == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionScenarioAddWithNullName", "Cannot add a scenario that has a null name into the scenario collection");
        }
        if (this.isExistingScenarioName(newScenarioDef.getName())) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionAddScenarioAlreadyExists", "Cannot add scenario; a scenario named {0} already exists.", newScenarioDef.getName());
        }
        this.m_scenarioDefs.put(newScenarioDef.getName(), newScenarioDef);
        newScenarioDef.setScenarioCollection(this);
    }

    public VWScenarioDefinition removeScenario(String scenarioName) throws VWException {
        if (scenarioName == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinition.NullNameParameter", "The name parameter cannot be null.");
        }
        if (this.m_scenarioDefs.containsKey(scenarioName)) {
            VWScenarioDefinition scenarioDef = (VWScenarioDefinition)this.m_scenarioDefs.remove(scenarioName);
            if (scenarioDef != null) {
                scenarioDef.setScenarioCollection(null);
            }
            return scenarioDef;
        }
        throw new VWException("sim.api.VWScenarioCollectionDefinition.ScenarioNotFound", "No scenario found with name equal to {0} in the scenario collection.", scenarioName);
    }

    public VWScenarioDefinition getScenario(String scenarioName) throws VWException {
        if (scenarioName == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinition.NullNameParameter", "The name parameter cannot be null.");
        }
        if (this.m_scenarioDefs.containsKey(scenarioName)) {
            return (VWScenarioDefinition)this.m_scenarioDefs.get(scenarioName);
        }
        throw new VWException("sim.api.VWScenarioCollectionDefinitionScenarioNotFound", "No scenario found with name equal to \"{0}\" in the scenario collection.", scenarioName);
    }

    public VWScenarioDefinition[] getScenarios() {
        VWScenarioDefinition[] result = null;
        if (this.m_scenarioDefs.size() != 0) {
            result = this.m_scenarioDefs.values().toArray(new VWScenarioDefinition[0]);
        }
        return result;
    }

    public boolean isExistingScenarioName(String scenarioName) throws VWException {
        if (scenarioName == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinition.NullNameParameter", "The name parameter cannot be null.");
        }
        return this.m_scenarioDefs.containsKey(scenarioName);
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        VWScenarioDefinition[] scenarioDefs = this.getScenarios();
        if (scenarioDefs != null) {
            theBuffer.append(indentA + "<fn:ScenarioDefinitions>\n");
            for (int nIndex = 0; nIndex < scenarioDefs.length; ++nIndex) {
                scenarioDefs[nIndex].toXPDL_withNoXMLDeclaration(theBuffer);
            }
            theBuffer.append(indentA + "</fn:ScenarioDefinitions>\n");
        }
    }

    protected void updateScenarioNameInList(String currentName, String newName) throws VWException {
        if (this.isExistingScenarioName(newName)) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionDuplicateName", "A scenario definition with the name \"{0}\" already exists in the scenario collection.", newName);
        }
        VWScenarioDefinition scenarioDef = this.removeScenario(currentName);
        if (scenarioDef == null) {
            throw new VWException("sim.api.VWScenarioCollectionDefinitionScenarioNotFound", "No scenario found with name equal to \"{0}\" in the scenario collection.", currentName);
        }
        this.m_scenarioDefs.put(newName, scenarioDef);
        scenarioDef.setScenarioCollection(this);
    }
}

